
PROCEDURE DIJKSTRA(
       N,INF,S,T:INTEGER;
   VAR W        :ARRNN;
   VAR PATH     :BOOLEAN;
   VAR FINAL    :BOOLARRN;
   VAR DIST,PRED:ARRN);

   VAR U,V,Y,RECENT,NEWLABEL,TEMP:INTEGER;
BEGIN
   FOR V:=1 TO N DO BEGIN
      DIST[V]:=INF;  FINAL[V]:=FALSE;  PRED[V]:=-1
   END;                       { INF = WEIGHT OF A  NONEXISTENT EDGE }
   DIST[S]:=0;  FINAL[S]:=TRUE;
   PATH:=TRUE;  RECENT:=S;                    { INITIALIZATION OVER }
   WHILE NOT FINAL[T] DO BEGIN
      FOR V:=1 TO N DO                             { FIND NEW LABEL }
         IF (W[RECENT,V] < INF) AND (NOT FINAL[V]) THEN BEGIN
            NEWLABEL:=DIST[RECENT]+W[RECENT,V];
            IF NEWLABEL < DIST[V] THEN BEGIN
               DIST[V]:=NEWLABEL;  PRED[V]:=RECENT
            END
         END;
      TEMP:=INF;
      FOR U:=1 TO N DO               { FIND SMALLEST LABELED VERTEX }
         IF (NOT FINAL[U]) AND (DIST[U] < TEMP) THEN  BEGIN
            Y:=U;  TEMP:=DIST[U]
         END;
      IF TEMP < INF THEN BEGIN                    { THERE IS A PATH }
         FINAL[Y]:=TRUE;  RECENT:=Y
      END
      ELSE BEGIN                     { THERE IS NO PATH FROM S TO T }
         PATH:=FALSE;  FINAL[T]:=TRUE
      END
   END  { WHILE NOT FINAL[T] }
END;  { DIJKSTRA }

